<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class EntryType
 * @package App\Models
 * @version November 26, 2019, 3:35 am UTC
 *
 * @property string name
 */
class EntryType extends Model
{
    //use SoftDeletes;

    public $table = 'entry_types';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'label',
        'description',
        'base_type',
        'numbering',
        'prefix',
        'prefix',
        'zero_padding',
        'restriction_bankcash',
        'tag_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'name' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required|unique:entry_types'
    ];

    public function tag(){
        return $this->belongsTo('App\Models\EntryTag','tag_id');
    }
   
}
