<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ConsumableSettings
 * @package App\Models
 * @version October 19, 2019, 5:34 pm UTC
 *
 */
class ConsumableSettingsDetail extends Model
{
   // use SoftDeletes;

    public $table = 'consumable_details';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'consumable_id',
        'item_id',
        'qty',
        'qty_type',
        'expected_pcs'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'qty' => 'float',
        'expected_pcs' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'qty' => 'nullable|numeric',
        'expected_pcs' => 'nullable|numeric'
    ];

    public function item()
    {
        return $this->belongsTo('App\Models\ConsumableItem','item_id');
    }
    
}
