<?php 

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\ConsumableItem;

class ConsumableConsumpationDetailResource extends BaseJsonResource
{
    public function toArray($request)
    {
        $item = ConsumableItem::find($this->consumable_id);

        $array = [
            'id' => $this->id,
            'qty' => (float)$this->qty,
            'consumed_percentage' => (float)$this->consumed_percentage,
            'category' => $item->category()->first()->name,
            'item' => $item->name
        ];
        
        return $array;
    }
}