<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductionPackagingsTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production_packagings', function (Blueprint $table) {
            $table->unsignedBigInteger('packing_id')->nullable(false)->unique();
            $table->primary('packing_id');
            $table->decimal('qty', 25, 2)->default(0);
            //$table->unsignedBigInteger('qty_unit_id')->nullable(true);
            
            $table->string('narration')->nullable(true);

            $table->timestamps();
            //$table->softDeletes();

            //$table->foreign('qty_unit_id')->references('id')->on('units');

            $table->unsignedBigInteger('created_by')->nullable(false);
            $table->unsignedBigInteger('updated_by')->nullable();
            //$table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users');
            $table->foreign('updated_by')->references('id')->on('users');        
           // $table->foreign('deleted_by')->references('id')->on('users');   
            
            

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('production_packagings');
    }
}
