<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Account
 * @package App\Models
 * @version November 18, 2019, 6:49 pm UTC
 *
 * @property string name
 */
class Account extends CRUDAwareModel
{
   // use SoftDeletes;

    public $table = 'accounts';
    

    protected $dates = ['deleted_at'];


    public $fillable = [
        'name',
        'code',
        'group_id',
        'balance_cr',
        'balance_dr',
        'type',
        'reconciliation',
        'phoneNo',
        'email',
        'gstNo',
        'billing_address',
        'shipping_address',
        'created_by',
        'updated_by',
        'state_id',
        'contact_person'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'name' => 'string',
        'blance_cr' => 'float',
        'balance_dr' => 'float'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'name' => 'required|unique:accounts',
        'op_balance' => 'nullable|numeric',
        'op_balance_dc' => 'nullable|numeric'
    ];

    public function group()
    {
        return $this->belongsTo('App\Models\AccountGroup', 'group_id');
    }

    public function state()
    {
        return $this->belongsTo('App\Models\State', 'state_id');
    }

    
}
