<?php 

namespace App\Http\Resources\Bond;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\BaseJsonResource;

class BondResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'name' => $this->name,
            'name_print' => $this->name_print,
            'machine_type' => $this->machine_type,
            'stone_type' => $this->stone_type,
            'bond_short_description' => $this->bond_short_description,
            'status' => $this->status,
            'bond_process' => new BondProcessResource($this->bondProcessParam)
        ];

        $array = $this->base($array);
        
        return $array;
    }
}