<?php

namespace App\Http\Controllers;

use App\DataTables\AccountGroupDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateAccountGroupRequest;
use App\Http\Requests\UpdateAccountGroupRequest;
use App\Repositories\AccountGroupRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class AccountGroupController extends AppBaseController
{
    /** @var  AccountGroupRepository */
    private $accountGroupRepository;

    public function __construct(AccountGroupRepository $accountGroupRepo)
    {
        $this->accountGroupRepository = $accountGroupRepo;
    }

    /**
     * Display a listing of the AccountGroup.
     *
     * @param AccountGroupDataTable $accountGroupDataTable
     * @return Response
     */
    public function index(AccountGroupDataTable $accountGroupDataTable)
    {
        return $accountGroupDataTable->render('account_groups.index');
    }

    /**
     * Show the form for creating a new AccountGroup.
     *
     * @return Response
     */
    public function create()
    {
        return view('account_groups.create');
    }

    /**
     * Store a newly created AccountGroup in storage.
     *
     * @param CreateAccountGroupRequest $request
     *
     * @return Response
     */
    public function store(CreateAccountGroupRequest $request)
    {
        $input = $request->all();

        $accountGroup = $this->accountGroupRepository->create($input);

        Flash::success('Account Group saved successfully.');

        return redirect(route('accountGroups.index'));
    }

    /**
     * Display the specified AccountGroup.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $accountGroup = $this->accountGroupRepository->find($id);

        if (empty($accountGroup)) {
            Flash::error('Account Group not found');

            return redirect(route('accountGroups.index'));
        }

        return view('account_groups.show')->with('accountGroup', $accountGroup);
    }

    /**
     * Show the form for editing the specified AccountGroup.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $accountGroup = $this->accountGroupRepository->find($id);

        if (empty($accountGroup)) {
            Flash::error('Account Group not found');

            return redirect(route('accountGroups.index'));
        }

        return view('account_groups.edit')->with('accountGroup', $accountGroup);
    }

    /**
     * Update the specified AccountGroup in storage.
     *
     * @param  int              $id
     * @param UpdateAccountGroupRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateAccountGroupRequest $request)
    {
        $accountGroup = $this->accountGroupRepository->find($id);

        if (empty($accountGroup)) {
            Flash::error('Account Group not found');

            return redirect(route('accountGroups.index'));
        }

        $accountGroup = $this->accountGroupRepository->update($request->all(), $id);

        Flash::success('Account Group updated successfully.');

        return redirect(route('accountGroups.index'));
    }

    /**
     * Remove the specified AccountGroup from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $accountGroup = $this->accountGroupRepository->find($id);

        if (empty($accountGroup)) {
            Flash::error('Account Group not found');

            return redirect(route('accountGroups.index'));
        }

        $this->accountGroupRepository->delete($id);

        Flash::success('Account Group deleted successfully.');

        return redirect(route('accountGroups.index'));
    }
}
