<?php 

namespace App\Http\Resources\Production;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class QualityCheckResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'material_id' => $this->material_id,
            'qty' =>  $this->qty,
            'rejection_under_size_qty' => $this->rejection_under_size_qty,
            'rejection_over_size_qty' =>  $this->rejection_over_size_qty,
            'rejection_shape_qty' =>  $this->rejection_shape_qty,
            'net_qty' =>  $this->net_qty,
            'rejection_reason' => $this->rejection_reason,
            'reason' => $this->reason,
            'bond_product' => $this->material->bondproduct->name
        ];
        
        $array = $this->base($array);
        return $array;
    }
}