<?php

namespace App\DataTables;

use App\Models\BondRecipeProduction;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class BondRecipeProductionDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $dataTable->addColumn('duration', function (BondRecipeProduction $album) {
            $days = (($album->duration)/(60*60*24));
            if($days>0){
                return $days." day";
            }else{
                return (($album->duration)/(60*60)).' hour';
            }
           
        });

        // $dataTable->addColumn('status', function (BondRecipeProduction $album) {
        //     if(!empty($album->getProductionStatus()->first())){
        //         return $album->getProductionStatus()->first()->status;
        //     }
        //     return "";
        // });

        return $dataTable->addColumn('action', 'bond_recipe_productions.datatables_actions');
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\BondRecipeProduction $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(BondRecipeProduction $model)
    {
        return $model->newQuery();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->addAction(['width' => '120px', 'printable' => false])
            ->parameters([
                'dom'       => 'Bfrtip',
                'stateSave' => true,
                'order'     => [[0, 'desc']],
                'buttons'   => [
                    ['extend' => 'create', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'export', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'print', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reset', 'className' => 'btn btn-default btn-sm no-corner',],
                    ['extend' => 'reload', 'className' => 'btn btn-default btn-sm no-corner',],
                ],
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            'material_id',
            'start_time',
            'end_time',
            'duration',
            'mould',
            'remaining_piece',
            'electricity_out_duration' => ['title' => 'Ele. Out'],
            'other_prod_blocker_duration' => ['title' => 'Other Blocker'],
            'other_blocker_reason' => ['title' => 'Reason'],
           
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'bond_recipe_productionsdatatable_' . time();
    }
}
