<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntriesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('entries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('entrytype_id');
            $table->string('ref_number');
            $table->date('tr_date');

            $table->unsignedBigInteger('invoice_ref_id')->nullable(true);
            //$table->string('invoice_type')->nullable(true);

            $table->decimal('cr_total', 25, 2)->default(0);
            $table->decimal('dr_total', 25, 2)->default(0);

            $table->text('narration')->nullable(true);
            $table->timestamps();
            //$table->softDeletes();

            $table->foreign('entrytype_id')->references('id')->on('entry_types');
        });

        Schema::create('entryitems', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('entry_id');
            $table->unsignedBigInteger('account_id');
            $table->decimal('cr_total', 25, 2);
            $table->decimal('dr_total',25,2);
            $table->date('reconciliation_date');

            $table->timestamps();
            //$table->softDeletes();

            $table->foreign('entry_id')->references('id')->on('entries')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('entries');
        Schema::drop('entryitems');
    }
}
