<?php 

namespace App\Http\Resources\Consumable;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\User;
use App\Http\Resources\BaseJsonResource;

class ConsumableSettingResource extends BaseJsonResource
{
    public function toArray($request)
    {

        $array = [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'alias' => $this->alias,
            'type' => $this->type,
            'qty' => $this->qty,
            'qty_type' => $this->qty_type,
            'expected_pcs' => $this->expected_pcs,
            'items' => ConsumableSettingItemResource::collection($this->items)
        ];

        $array = $this->base($array);
        
        return $array;
    }
}