<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrinterTemplatesTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('printer_templates', function (Blueprint $table) {
            $table->integer('num_of_copies')->nullable(true);
            $table->integer('lmargin')->default(0)->nullable(true);
            $table->integer('rmargin')->default(0)->nullable(true);
            $table->integer('tmargin')->default(0)->nullable(true);
            $table->integer('bmargin')->default(0)->nullable(true);
            $table->integer('lpad')->default(0)->nullable(true);
            $table->integer('rpad')->default(0)->nullable(true);
            $table->integer('tpad')->default(0)->nullable(true);
            $table->integer('bpad')->default(0)->nullable(true);
            $table->string('color_mode')->nullable(true);
            $table->integer('page_length')->default(0)->nullable(true);
            $table->integer('page_width')->default(0)->nullable(true);
            $table->integer('duplex_mode')->default(0)->nullable(true);
            $table->string('orientation')->nullable(true);
            $table->string('page_size')->nullable(true);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('printer_templates');
    }
}
