<?php 

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;

class BasePaginationResourceCollection extends ResourceCollection
{
    private $pagination;

    private $clazzName;

    public function __construct($pageData, $data, $clazzName, $count=null)
    {
        if(isset($count)){
            $this->pagination = [
                'total' => 1,
                'count' => 1,
                'per_page' => $count,
                'current_page' => 1,
                'total_pages' => 1,
            ];
        }else{
            $this->pagination = [
                'total' => $pageData->total(),
                'count' => $pageData->count(),
                'per_page' => $pageData->perPage(),
                'current_page' => $pageData->currentPage(),
                'total_pages' => $pageData->lastPage(),
            ];
        }
        
        $this->clazzName = $clazzName;

        parent::__construct($data);
    }

    public function toArray($request)
    {
       // dd($this->collection['data']);
       if(empty($this->clazzName)){
        return [
            'data' => $this->collection,
            'pagination' => $this->pagination
        ];   
       }
       
        return [
            'data' => $this->clazzName::collection($this->collection),
            'pagination' => $this->pagination
        ];
    }
    
}