<?php

namespace App\Http\Controllers;

use App\DataTables\BinderCompositionDataTable;
use App\Http\Requests;
use App\Http\Requests\CreateBinderCompositionRequest;
use App\Http\Requests\UpdateBinderCompositionRequest;
use App\Repositories\BinderCompositionRepository;
use Flash;
use App\Http\Controllers\AppBaseController;
use Response;

class BinderCompositionController extends AppBaseController
{
    /** @var  BinderCompositionRepository */
    private $binderCompositionRepository;

    public function __construct(BinderCompositionRepository $binderCompositionRepo)
    {
        $this->binderCompositionRepository = $binderCompositionRepo;
    }

    /**
     * Display a listing of the BinderComposition.
     *
     * @param BinderCompositionDataTable $binderCompositionDataTable
     * @return Response
     */
    public function index(BinderCompositionDataTable $binderCompositionDataTable)
    {
        return $binderCompositionDataTable->render('binder_compositions.index');
    }

    /**
     * Show the form for creating a new BinderComposition.
     *
     * @return Response
     */
    public function create()
    {
        return view('binder_compositions.create');
    }

    /**
     * Store a newly created BinderComposition in storage.
     *
     * @param CreateBinderCompositionRequest $request
     *
     * @return Response
     */
    public function store(CreateBinderCompositionRequest $request)
    {
        $input = $request->all();

        $binderComposition = $this->binderCompositionRepository->create($input);

        Flash::success('Binder Composition saved successfully.');

        return redirect(route('binderCompositions.index'));
    }

    /**
     * Display the specified BinderComposition.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            Flash::error('Binder Composition not found');

            return redirect(route('binderCompositions.index'));
        }

        return view('binder_compositions.show')->with('binderComposition', $binderComposition);
    }

    /**
     * Show the form for editing the specified BinderComposition.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            Flash::error('Binder Composition not found');

            return redirect(route('binderCompositions.index'));
        }

        return view('binder_compositions.edit')->with('binderComposition', $binderComposition);
    }

    /**
     * Update the specified BinderComposition in storage.
     *
     * @param  int              $id
     * @param UpdateBinderCompositionRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBinderCompositionRequest $request)
    {
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            Flash::error('Binder Composition not found');

            return redirect(route('binderCompositions.index'));
        }

        $binderComposition = $this->binderCompositionRepository->update($request->all(), $id);

        Flash::success('Binder Composition updated successfully.');

        return redirect(route('binderCompositions.index'));
    }

    /**
     * Remove the specified BinderComposition from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $binderComposition = $this->binderCompositionRepository->find($id);

        if (empty($binderComposition)) {
            Flash::error('Binder Composition not found');

            return redirect(route('binderCompositions.index'));
        }

        $this->binderCompositionRepository->delete($id);

        Flash::success('Binder Composition deleted successfully.');

        return redirect(route('binderCompositions.index'));
    }
}
