<?php

namespace App\DataTables;

use App\Models\Album;
use Yajra\DataTables\Services\DataTable;
use Yajra\DataTables\EloquentDataTable;

class BaseDataTable extends DataTable
{

    protected function getLocaleString($model){
        $t='';
        $tr = $model->getTranslation('name','hi');
        if(!empty($tr)){
            $t = $t.'<span class="label label-info">hi</span>';
        }
        $t = $t .'<span class="label label-success"> en</span>';
        return $t;
    }

    protected function getLocaleStringTitle($model){
        $t='';
        $tr = $model->getTranslation('title','hi');
        if(!empty($tr)){
            $t = $t.'<span class="label label-info">hi</span>';
        }
        $t = $t .'<span class="label label-success"> en</span>';
        return $t;
    }

    protected function getString($array){
        $t='';
        foreach($array as $item){
            if(!empty($item)){
                $t = $t.'<span class="label label-info">'.mb_strimwidth($item, 0,20,'..').'</span><br>';
            }
        }
        return $t;
    }

    protected function getUnformattedString($array){
        $t='';
        foreach($array as $item){
            if(!empty($item)){
                $t = $t.mb_strimwidth($item, 0,10,'..');
            }
        }
        return $t;
    }
}